package AppGioco;

import java.util.*;

public class Partita {
	private final String codice;
	private LinkedList<TipoLinkGiocato> giocato;
	public static final int MOLT_MIN = 1;

	public Partita(String c) {
		codice = c;
		giocato = new LinkedList<TipoLinkGiocato>();
	}

	public String getCodice() {
		return codice;
	}

	public int quantiLinkGiocato() {
		return giocato.size();
	}

	public void inserisciLinkGiocato(TipoLinkGiocato t) {
		if (t != null && t.getPartita() == this)
			ManagerGiocato.inserisci(t);
	}

	public void eliminaPerManagerGiocato(TipoLinkGiocato t) {
		if (t != null && t.getPartita() == this)
			ManagerGiocato.elimina(t);
	}

	public void inserisciPerManagerGiocato(ManagerGiocato a) {
		if (a != null && !giocato.contains(a.getLink()))
			giocato.add(a.getLink());
	}

	public void eliminaPerManagerGiocato(ManagerGiocato a) {
		if (a != null)
			giocato.remove(a.getLink());
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkGiocato> getLinkGiocato() throws EccezioneMolteplicita {
		if (giocato.size() < MOLT_MIN)
			throw new EccezioneMolteplicita("Molteplicita' minima violata");
		return (LinkedList<TipoLinkGiocato>) giocato.clone();
	}

	public String toString() {
		return codice;
	}
}
